# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:057 (valgrind)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63448);
 script_cve_id("CVE-2008-4865");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:057 (valgrind)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to valgrind
announced via advisory MDVSA-2009:057.

A vulnerability has been identified and corrected in valgrind:

Untrusted search path vulnerability in valgrind before 3.4.0
allows local users to execute arbitrary programs via a Trojan horse
.valgrindrc file in the current working directory, as demonstrated
using a malicious --db-command options. NOTE: the severity of this
issue has been disputed, but CVE is including this issue because
execution of a program from an untrusted directory is a common
scenario. (CVE-2008-4865)

The updated packages have been patched to prevent this.

Affected: 2008.0, 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:057

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:057 (valgrind)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"valgrind", rpm:"valgrind~3.2.3~2.2mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"valgrind", rpm:"valgrind~3.3.0~3.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"valgrind", rpm:"valgrind~3.3.1~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
