# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:064 (imap)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63481);
 script_cve_id("CVE-2008-5005");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:064 (imap)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to imap
announced via advisory MDVSA-2009:064.

Security vulnerabilities has been identified and fixed in University
of Washington IMAP Toolkit which could allow local users to gain
privileges by specifying incorrect folder name (CVE-2008-5005).

The updated packages have been patched to prevent this.

Affected: Corporate 3.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:064

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:064 (imap)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"imap", rpm:"imap~2002d~8.4.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-devel", rpm:"imap-devel~2002d~8.4.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-utils", rpm:"imap-utils~2002d~8.4.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
