###############################################################################
# OpenVAS Vulnerability Test
# $Id: proxy_use.nasl 2942 2009-03-28 18:13:00Z mime $
#
# HTTP Proxy Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(100083);
 script_version ("1.0");

 name["english"] = "HTTP Proxy Server Detection";
 script_name(english:name["english"]);
 
 desc["english"] = "

  Overview:
   
   A HTTP proxy server is running at this Host and accepts
   unauthenticated requests from the OpenVAS Scanner.

   An open proxy is a proxy server that is accessible by any Internet
   user. Generally, a proxy server allows users within a network group
   to store and forward Internet services such as DNS or web pages to
   reduce and control the bandwidth used by the group. With an open
   proxy, however, any user on the Internet is able to use this
   forwarding service.

  Solution:
   Limit access to the proxy to valid users and/or valid hosts.

  Risk factor : None";

 script_description(english:desc["english"]);
 summary["english"] = "HTTP Proxy Server Detection";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 family["english"] = "Firewalls";
 script_family(english:family["english"]);
 script_dependencies("find_service.nes");
 script_require_ports("Services/http_proxy", 3128, 8080, 6588, 8000);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");

ports = add_port_in_list(list:get_kb_list("Services/http_proxy"));
port_list = make_list("3128","8080","6588","8000","80");

foreach add_port (port_list) {
 if(get_port_state(add_port)) {
   ports = add_port_in_list(list:ports, port:add_port);
 }
}

if(!ports)exit(0);

foreach port (ports) {
 
 url = 'http://www.openvas.org/openvas-proxy-test';
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 
 if( buf == NULL )continue;

 if ( "%%openvas-proxy-test%%" >< buf ) {

  set_kb_item(name:"Proxy/usage", value:TRUE);
  set_kb_item(name:"Services/http_proxy", value:port);

  if(egrep(pattern: "squid", string: buf, ICASE:TRUE)) {
   if(!get_kb_item("www/squid")) { 
    	set_kb_item(name:"www/squid", value:TRUE);
   } 
  }  

  if(VIA = egrep(pattern: "^Via:.*$", string: buf)) {
   if(VIA = eregmatch(pattern: "^Via: (.*)$", string: VIA)) {
    set_kb_item(name:string("Proxy/" + port  + "/via"), value: chomp(VIA[1])); 
   }
  }

  security_note(port:port);

 }
}

exit(0);
