#################################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_imeraieplugin_actvx_ctrl_vuln.nasl 757 2009-03-20 10:47:41Z mar $
#
# Imera TeamLinks ImeraIEPlugin.dll ActiveX Control DoS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#################################################################################

if(description)
{
  script_id(900520);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0813");
  script_bugtraq_id(33993);
  script_name(english:"Imera TeamLinks ImeraIEPlugin.dll ActiveX Control DoS Vulnerability");
  desc["english"] = "

  Overview: This host is installed with Imera ImeraIEPlugin ActiveX and
  is prone to denial of service vulnerability.

  Vulnerability Insight:
  This issue is caused by errors in the ImeraIEPlugin.dll control while
  processing the URLs passed into DownloadProtocol, DownloadHost, DownloadPort
  and DownloadURI parameters.

  Impact:
  Attacker may exploit this issue to download and execute arbitrary script code
  on the victim's system by passing malicious URLs and may crash the application.

  Impact Level: System/Application

  Affected Software/OS:
  Imera Systems ImeraIEPlugin.dll version 1.0.2.54 on Windows.

  Fix: No solution or patch is available as on 23rd March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.imera.com/index.html

  Workaround:
  Set the killbit for the CLSID {75CC8584-86D4-4A50-B976-AA72618322C6}
  http://support.microsoft.com/kb/240797

  References:
  http://milw0rm.com/exploits/8144
  http://xforce.iss.net/xforce/xfdb/49028
  http://seclists.org/fulldisclosure/2009/Mar/0086.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.0
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ImeraIEPlugin.dll");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

imeraName = registry_get_sz(key:"SOFTWARE\ImeraIBCPilot", item:"Name");
if("Imera TeamLinks" >< imeraName)
{
  imeraPath = registry_get_sz(key:"SOFTWARE\ImeraIBCPilot", item:"Install_Dir");
  if(imeraPath == NULL){
    exit(0);
  }
}

imeraPath = imeraPath + "\ImeraIEPlugin\ImeraIEPlugin.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:imeraPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:imeraPath);
imeradllVer = GetVer(share:share, file:file);

# Check for version of ImeraIEPlugin.dll
if(imeradllVer != NULL)
{
  if(version_is_less_equal(version:imeradllVer, test_version:"1.0.2.54"))
  {
    if(is_killbit_set(clsid:"{75CC8584-86D4-4A50-B976-AA72618322C6}") == 0){
      security_hole(0);
    }
  }
}
