###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pango_detect.nasl 2243 2009-05-20 15:21:24Z may $
#
# Pango Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900643);
  script_version("Revision: 1.0 ");
  script_name(english:"Pango Version Detection");
  desc["english"] = "

  Overview: This script detects the installed version of Pango and sets the
  result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of Pango");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"pango-view", sock:sock);
foreach pangobin (paths)
{
  pangoVer = get_bin_version(full_prog_name:chomp(pangobin), sock:sock,
                             version_argv:"--version", ver_pattern:"([0-9.]+)");
  if(pangoVer[1] != NULL){
    set_kb_item(name:"Pango/Ver", value:pangoVer[1]);
  }
}
ssh_close_connection();
