##############################################################################
#
#  Personal FTP Server RETR Command Remote Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/18
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0237
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900127);
 script_bugtraq_id(31173);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"Personal FTP Server RETR Command Remote Denial of Service Vulnerability");
 script_summary(english:"Check for vulnerable version of Personal FTP Server");
 desc["english"] = "
 Overview : The host is running Personal FTP Server, which is prone to denial 
 of service vulnerability.

 Vulnerability Insight :

        This issue is caused due to an error when handling the RETR command.

        Impact : Successful exploitation will deny the service by sending
        multiple RETR commands with an arbitrary argument.

 Impact Level : Application

 Affected Software/OS :
        Michael Roth Personal FTP Server 6.0f and prior on Windows (all).
 
 Fix : No solution/patch is available as on 16th September, 2008. Information
 regarding this issue will be updated once the solution details are available.
 For updates check, http://www.michael-roth-software.de/new/Produkte.html

 References : http://shinnok.evonet.ro/vulns_html/pftp.html 
 http://downloads.securityfocus.com/vulnerabilities/exploits/31173.c

 CVSS Score :
        CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C)
        CVSS Temporal Score : 5.7
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports("Services/ftp", 21);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }
 
 port = get_kb_item("Services/ftp");
 if(!port){
        port = 21;
 }

 if(!get_port_state(port)){
        exit(0);
 }

 pftpVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\Uninstall\The Personal FTP Server_is1",
                           item:"DisplayVersion");

 if(egrep(pattern:"^([0-5]\..*|6\.0([a-f])?)$", string:pftpVer)){
        security_warning(port);
 }
