###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sdp_downloader_detect.nasl 2009-05-19 09:07:05Z may $
#
# SDP Downloader Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900641);
  script_version("$Revision: 1.0 $");
  script_name(english:"SDP Downloader Version Detection");
  desc["english"] = "

  Overview: This script detects the installed version of SDP Downloader
  and sets the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB for the Version of SDP Downloader");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

sdpKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item(registry_enum_keys(key:sdpKey))
{
  sdpName = registry_get_sz(key:sdpKey + item, item:"DisplayName");

  if("SDP Downloader" >< sdpName)
  {
    sdpVer = registry_get_sz(key:sdpKey + item, item:"DisplayVersion");
    if(sdpVer){
      set_kb_item(name:"SDP/Downloader/Ver", value:sdpVer);
    }
    exit(0);
  }
}
