##############################################################################
#
#  Titan FTP Server 'SITE WHO' Command Remote DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/21
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0357
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900160);
  script_bugtraq_id(31757);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"Titan FTP Server 'SITE WHO' Command Remote DoS Vulnerability");
  script_summary(english:"Check for vulnerable version of Titan FTP Server");
  desc["english"] = "
  Overview : The host is running Titan FTP Server and is prone to denial of
  service vulnerability.

  The flaw is caused due to error in the 'SITE WHO' command processing, which 
  can be exploited to exhaust available CPU resources.

  Impact :
  Successful exploitation will cause denial of service.

  Impact Level : Application

  Affected Software/OS :
  South River Technologies Titan FTP Server versions prior to 6.26.631 

  Fix : Update to version 6.26.631 or later
  http://www.titanftp.com/download/index.html

  References :
  http://milw0rm.com/exploits/6753
  http://secunia.com/advisories/32269/

  CVSS Score :
    CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C)
    CVSS Temporal Score : 4.9
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_dependencie("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}

include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("Titan FTP Server" >< banner)
{
  # Grep versions prior to 6.26.631
  if(egrep(pattern:"Titen FTP Server ([0-5](\..*)|6(\.[01]?[0-9]|\.2[0-6])" +
                   "(\.[0-5]?[0-9]?[0-9]?|\.6[0-2][0-9]|\.630))($|[^.0-9])",
            string:banner))
  {
    security_warning(port);
    exit(0);
  }
}
