##############################################################################
#
#  VLC Media Player TTA Processing Integer Overflow Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/19
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0131
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900112);
 script_bugtraq_id(30718);
 script_copyright(english:"Copyright 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"VLC Media Player TTA Processing Integer Overflow Vulnerability");
 script_summary(english:"Check for vulnerable version of VLC Media Player");
 desc["english"] = "
 Overview : The host is running VLC Media Player, which is prone to a integer
 overflow vulnerability.

 Vulnerability Insight :

        The flaw is due to an overflow error when processing TTA data in Open()
        method in modules/demux/tta.c file.

        Impact : Remote exploitation will cause application to crash or allow
        execution of arbitrary code or deny the service.

 Impact Level : Application

 Affected Software/OS :
        VLC Media Player version 0.8.6i and prior on Windows (All).
 
 Fix : No solution/patch is available as on 19th August, 2008. Information
 regarding this issue will update once the solution details are available.
 For updates refer, http://www.videolan.org/

 References :
 http://www.orange-bat.com/adv/2008/adv.08.16.txt
 http://www.frsirt.com/english/advisories/2008/2394

 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 6.4
 Risk factor : High";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 vlcVer = registry_get_sz(key:"SOFTWARE\VideoLAN\VLC", item:"Version");
 if(egrep(pattern:"^0\.([0-7]\..*|8\.([0-5][a-z]?|6[a-i]?))$", string:vlcVer)){
	security_warning(0);
 }
