#############################################################################
#
#  Wireshark Multiple Vulnerabilities - Sept-08 (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/09
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0172
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

 desc["english"] = "
        Impact : Successful exploitation could result in denial of service
        condition or application crash by injecting a series of malformed
        packets or by convincing the victim to read a malformed packet.

 Impact Level : Application

 Affected Software/OS :
        Wireshark versions 1.0.2 and prior on Windows (All).

 Fix : Upgrade to wireshark 1.0.3 or later.
 http://www.wireshark.org/download.html
 
 References : http://secunia.com/advisories/31674
 http://www.frsirt.com/english/advisories/2008/2493
 http://www.wireshark.org/security/wnpa-sec-2008-05.html
 
 CVSS Score Report :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 5.3
 Risk factor : High";
if(description)
{
 script_id(900212);
 script_bugtraq_id(31009);
 script_cve_id("CVE-2008-3146", "CVE-2008-3932", "CVE-2008-3933");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Denial of Service");
 script_name(english:"Wireshark Multiple Vulnerabilities - Sept-08 (Win)");
 script_summary(english:"Check for vulnerable version of Wireshark/Ethereal");
 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 report = string("\n Overview : The host is running Wireshark/Ethereal, which" +
		 "is prone to multiple\n vulnerabilities.\n" +
		 "\n        Vulnerability Insight:\n" +
		 "\n        Flaw(s) is/are due to,\n");
 vuln1 = string("       - infinite loop errors in the NCP dissector.\n");
 vuln2 = string("       - an error when uncompressing zlib-compressed packet data.\n");
 vuln3 = string("       - an error when reading a Tektronix .rf5 file.\n");

 etherealVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"+
			       "\Uninstall\Ethereal", item:"DisplayVersion");
 if(etherealVer)
 {
	etherealVer = ereg_replace(pattern:"Ethereal (.*)", replace:"\1",
                            	   string:etherealVer);
	if(ereg(pattern:"^0\.(9\.[7-9]|10\.(0?[0-9]|1[0-3]))$",
		string:etherealVer))
	{
		security_hole(data:string(report, vuln1, desc["english"]));
		exit(0);
	}
	else if(ereg(pattern:"^0\.(10\.14|99\.0)$",
		     string:etherealVer))
	{
		security_hole(data:string(report, vuln1, vuln2, desc["english"]));
                exit(0);
        }
 }

 wiresharkVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"+
			        "\Uninstall\Wireshark", item:"DisplayVersion");
 if(!wiresharkVer){
	exit(0);
 }

 if(ereg(pattern:"^0\.99\.[1-5]$", string:wiresharkVer))
 {
	security_hole(data:string(report, vuln1, vuln2, desc["english"]));
	exit(0);
 }
 else if(ereg(pattern:"^(0\.99\.[6-9]|1\.0\.[0-2])$", string:wiresharkVer)){
	security_hole(data:string(report, vuln1, vuln2, vuln3, desc["english"]));
 }
