#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 02 $

if(description)
{

 script_id(90012);
 script_version ("$Revision: 02 $");
 script_cve_id("CVE-2008-2010");
 name["english"] = "Buffer overflow in Apple Quicktime Player";
 script_name(english:name["english"]);

 desc["english"] = "The remote host is probable affected by the vulnerabilitys described in
CVE-2008-0234 CVE-2008-2010

Checking if QuickTime version is less than 7.5

Impact
      Buffer overflow in Apple Quicktime Player 7.3.1.70
      and other versions before 7.4.1, when RTSP tunneling
      is enabled, allows remote attackers to execute
      arbitrary code via a long Reason-Phrase response
      to an rtsp:// request, as demonstrated using a
      404 error message.

      Unspecified vulnerability in Apple QuickTime Player
      on Windows XP SP2 and Vista SP1 allows remote attackers
      to execute arbitrary code via a crafted QuickTime media
      file. NOTE: as of 20080429, the only disclosure is a
      vague pre-advisory with no actionable information.
      However, because it is from a well-known researcher,
      it is being assigned a CVE identifier for tracking purposes. 

References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0234
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2010
    http://lists.apple.com/archives/security-announce/2008/Feb/msg00001.html
    http://lists.apple.com/archives/Security-announce/2008/Jun/msg00000.html

Solution:
    All Users should upgrade to the latest version.


Risk factor : High";

 script_description(english:desc["english"]);
 summary["english"] = "Test for Buffer overflow in Apple Quicktime Player";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is under GPLv2");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 exit(0);
}

#
# The code starts here
#

include("version_func.inc");
include("smbcl_func.inc");
if( check_smbcl() == 0 ) exit(0);

  test_version = "7.50.51";
  win_dir = get_windir();
  if( !isnull(win_dir) ) {
    test_file[0] = win_dir+"System32\QuickTime.qts";
    test_file[1] = "Programme\QuickTime\QuickTimePlayer.exe";
    test_file[2] = "Program Files\QuickTime\QuickTimePlayer.exe";
    foreach filespec (test_file) {
      r = smbgetdir(share: "C$", dir: filespec, typ: 1 );
      if( !isnull(r) ) {
          tmp_filename = get_tmp_dir()+"tmpfile"+rand();
          if( smbgetfile(share: "C$", filename: filespec, tmp_filename: tmp_filename) ) {
            v = GetPEFileVersion(tmp_filename:tmp_filename, orig_filename:filespec);
            unlink(tmp_filename);
            if( version_is_less(version: v, test_version: test_version) ) {
              security_hole(port:0, proto:"Win_Quicktime");
              report = report + "Fileversion : C$ "+filespec + " "+v+string("\n");
              security_hole(port:0, proto:"Win_Quicktime", data:report);
            }
            break;
          } else {
            report = string("Error getting SMB-File -> "+get_kb_item("SMB/ERROR")) + string("\n");
            security_note(port:0, proto:"Win_Quicktime", data:report);
          }
      }
    }
  }

exit(0);
