###############################################################################
# OpenVAS Vulnerability Test
# $Id: FtpXQ_36391.nasl 5407 2009-10-06 16:45:43Z mime $
#
# DataWizard FtpXQ Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100293);
 script_bugtraq_id(36391);
 script_version ("1.0-$Revision: 5407 $");

 script_name("DataWizard FtpXQ Remote Denial of Service Vulnerability");

desc = "Overview:
FtpXQ is prone to a remote denial-of-service vulnerability.

Remote attackers can cause the affected server to stop responding,
denying service to legitimate users.

FtpXQ 3.0 is vulnerable; other versions may also be affected.

References:
http://www.securityfocus.com/bid/36391
http://www.datawizard.net

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if FtpXQ version is 3.0");
 script_category(ACT_GATHER_INFO);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(port)){
  exit(0);
}

if(!banner = get_ftp_banner(port:port))exit(0);

if("FtpXQ" >!< banner)exit(0);

version = eregmatch(string: banner, pattern:"Version ([0-9.]+)");

if(!isnull(version[1])) {
 if(version_is_equal(version: version[1], test_version: "3.0")) {
  security_warning(port:port);
 }
}   


exit(0); 

     
