###############################################################################
# OpenVAS Vulnerability Test
# $Id: OpenX_37110.nasl 5963 2009-11-25 10:49:08Z mime $
#
# OpenX Arbitrary File Upload Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100364);
 script_bugtraq_id(37110);
 script_version ("1.0-$Revision: 5963 $");

 script_name("OpenX Arbitrary File Upload Vulnerability");

desc = "Overview:
OpenX is prone to a vulnerability that lets attackers upload arbitrary
files because the application fails to adequately validate user-
supplied input.

An attacker can exploit this vulnerability to upload arbitrary code
and execute it in the context of the webserver process. This may
facilitate unauthorized access or privilege escalation; other attacks
are also possible.

The issue affects OpenX 2.8.1 and prior.

Solution:
Reportedly, the vendor fixed this issue in OpenX 2.8.2. Symantec has
not confirmed this information. Please contact the vendor for details.

References:
http://www.securityfocus.com/bid/37110
http://www.openx.org/
http://www.securityfocus.com/archive/1/508050

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine the OpenX version.");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("OpenX_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/openx")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "2.8.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
