#
# This script was written by Georges Dagousset <georges.dagousset@alert4web.com>
#
# Changes by Tenable Network Security : cleanup + better detection
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10794);
 script_version ("$Revision: 4330 $");
 name = "pcAnywhere TCP";
 script_name(name);

 desc = "pcAnywhere is running on this port

Solution : Disable this service if you do not use it.

Risk factor : None";

 script_description(desc);
 summary = "Checks for the presence pcAnywhere";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("This script is Copyright (C) 2001 Alert4Web.com");

 family = "Windows";
 script_family(family);
 script_dependencie("os_fingerprint.nasl", "find_service.nes");
 script_require_ports("Services/unknown", 5631);
 exit(0);
}

include("misc_func.inc");
include("global_settings.inc");

os = get_kb_item("Host/OS/smb");
if (!os || ("Windows" >!< os))
  exit(0);


function probe(port)
{
 soc = open_sock_tcp(port);
 if(soc)
 {
    send(socket:soc, data:raw_string(0,0,0,0));
    r = recv(socket:soc, length:36);
    if (r && ("Please press <" >< r))
    {
       register_service(port:port, proto:"pcanywheredata");
       security_note(port);
       exit(0);
    }
  close(soc);
 }
}



if ( thorough_tests ) port = get_kb_item("Services/unknown");
else port = 0;

if(port)
{
 if (! service_is_unknown (port: port)) exit(0);
 if(get_port_state(port))
  probe(port:port);
}
else 
{
 if(get_port_state(5631))
  probe(port:5631);
}
