###############################################################################
# OpenVAS Vulnerability Test
# $Id: WordPress_35755.nasl 6984 2010-03-17 12:20:23Z mime $
#
# WordPress Comment Author URI Cross-Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100239);
 script_bugtraq_id(35755);
 script_version ("1.0");

 script_name("WordPress Comment Author URI Cross-Site Scripting Vulnerability");

desc = "

Overview:
WordPress is prone to a cross-site scripting vulnerability because the
application fails to properly sanitize user-supplied input.

An attacker may leverage this issue to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may help the attacker steal cookie-based authentication
credentials and launch other attacks.

Versions prior to WordPress 2.8.2 are vulnerable.


Solution:
The vendor has released an update. Please see the references
for details.


References:
http://www.securityfocus.com/bid/35755
http://bugs.gentoo.org/show_bug.cgi?id=278492
http://wordpress.org/development/2009/07/wordpress-2-8-2/
http://wordpress.org/


Risk factor : Low";

 script_description(desc);
 script_summary("Determine if WordPress Version < 2.8.2");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("secpod_wordpress_detect_900182.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/WordPress")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "2.8.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
