# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if(description)
{
 script_id(11096);
 script_bugtraq_id(3901);
 script_version ("$Revision: 4300 $");
 script_cve_id("CVE-2002-0134");
 name = "Avirt gateway insecure telnet proxy";
 script_name(name);
 
 desc = "
It was possible to connect to the remote telnet server without
password and to get a command prompt with the 'DOS' command.

An attacker may use this flaw to get access on your system.

Solution : Contact your vendor for a patch or disable this service
Risk factor : High";

	 
 script_description(desc);
 
 summary = "Remote system compromise through insecure telnet proxy";
 script_summary(summary);
 
 script_category(ACT_ATTACK);
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 family = "Gain a shell remotely";
 script_family(family);
 script_require_ports("Services/telnet", 23);
 script_dependencies("find_service.nes");
 exit(0);
}

#
# The script code starts here
#
include('telnet_func.inc');
port = get_kb_item("Services/telnet");
if(!port)port = 23;
if (!get_port_state(port))  exit(0);

soc = open_sock_tcp(port);
if (!soc) exit(0);

banner = telnet_negotiate(socket:soc);
cmd = string("dos\r\n");
send(socket:soc, data:cmd);
res = recv(socket: soc, length: 512);

close(soc);
flag = egrep(pattern:"^[A-Z]:\\.*>", string: res);
if (flag) security_hole(port);
