###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# Axigen Mail Server HTML Injection Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100177);
 script_bugtraq_id(34716);
 script_cve_id("CVE-2009-1484");
 script_version ("1.0");

 script_name("Axigen Mail Server HTML Injection Vulnerability");
 desc = "

 Overview:
  Axigen Mail Server is prone to an HTML-injection vulnerability
  because the application fails to properly sanitize user-supplied
  input.

  Attacker-supplied HTML and script code would run in the context of
  the affected site, potentially allowing the attacker to steal
  cookie-based authentication credentials or to control how the site
  is rendered to the user; other attacks are also possible.

  Axigen Mail Server 6.2.2 is vulnerable; other versions may also be
  affected. 

 Solution:
  Reports indicate that fixes are available. Please contact the vendor
  for more information.

 See also:
  http://www.securityfocus.com/bid/34716

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Axigen is vulnerable to HTML Injection");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("axigen_web_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if(!version = get_kb_item(string("www/", port, "/axigen")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "6.2.2")) {
      security_warning(port:port);
      exit(0);
  }  

}

exit(0);
