###############################################################################
# OpenVAS Vulnerability Test
# $Id: bugzilla_38026.nasl 6619 2010-02-02 20:07:02Z mime $
#
# Bugzilla Group Selection During Bug Move Information Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100481);
 script_bugtraq_id(38026);
 script_cve_id("CVE-2009-3387");
 script_version ("1.0-$Revision: 6619 $");

 script_name("Bugzilla Group Selection During Bug Move Information Disclosure Vulnerability");

desc = "Overview:
Bugzilla is prone to an information-disclosure vulnerability.

Exploits may allow attackers to obtain potentially sensitive
information that may aid in other attacks.

This issue affects the following:

Bugzilla 3.3.1 through 3.4.4 Bugzilla 3.5.1 Bugzilla 3.5.2

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/38026
https://bugzilla.mozilla.org/show_bug.cgi?id=532493
http://www.bugzilla.org
http://www.bugzilla.org/security/3.0.10/

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if installed Bugzilla version is vulbnerable");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("bugzilla_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/bugzilla")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_in_range(version: vers, test_version: "3.3", test_version2: "3.4.4") ||
     version_in_range(version: vers, test_version: "3.5", test_version2: "3.5.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
