# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License. 
# Modified by Michael Meyer <michael.meyer@intevation.de>

if (description) {
 script_id(80037);
 script_version("$Revision: 1.5 $");
 script_description(desc);

 name = "Cisco VPN Client Version Detection";
 script_name(name);

 desc = "Overview: This script is detects the installed version of Cisco VPN
 Client and sets the result in KB.

 Risk Factor: Informational";
 script_description(desc);
 summary = "Detects the version number of the Cisco VPN Client in use";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2007 Ferdy Riphagen");
 script_require_ports(139, 445);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/login", "SMB/password", "SMB/name", "SMB/transport");
 exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
 exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Cisco Systems\VPN Client")){
  exit(0);  
}

key = "SOFTWARE\Cisco Systems\VPN Client";
path = registry_get_sz(key:key, item:"InstallPath");

if(path)
{
  file = path + "\vpngui.exe";
  version = GetVersionFromFile(file:file,verstr:"prod");
  if(!isnull(version)){
    set_kb_item(name:"SMB/CiscoVPNClient/Version", value:version);
    exit(0);
  } 
}

exit(0);
