#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
# Changes by rd :
# - script id
# - french desc.
# - more verbose report
# - hole -> warning
# 



if(description)
{
 script_id(10402);
 script_version ("$Revision: 4302 $");
 
 name = "CVSWeb detection";
 script_name(name);
 
 
desc = "
CVSWeb is used by hosts to share programming source 
code. Some web sites are misconfigured and allow access
to their sensitive source code without any password protection. 
This plugin tries to detect the presence of a CVSWeb CGI and
when it finds it, it tries to obtain its version.

Risk factor : Low
Solution : Password protect the CGI if unauthorized access isn't wanted";



 script_description(desc);
 
 summary = "Checks if CVSWeb is present and gets its version";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
  
 script_copyright("This script is Copyright (C) 2000 SecuriTeam");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

foreach dir (cgi_dirs())
{
 req = string(dir, "/cvsweb.cgi/");
 req = http_get(item:req, port:port);
 result = http_keepalive_send_recv(port:port, data:req);
 if( result == NULL ) exit(0);
 if("CVSweb $Revision:" >< result)
  {
   result = strstr(result, string("CVSweb $Revision: "));
   result = result - strstr(result, string(" $ -->\n"));
   result = result - "CVSweb $Revision: ";
   name = string("www/", port, "/cvsweb/version");
   set_kb_item(name:name, value:result);
   result = string(
"\nThe 'cvsweb' cgi is installed.\n",   
"cvsweb is used to browse the content of a CVS repository\n",
"It can be used by an intruder to obtain the source of your\n",
"programs if you keep them secret.\n\n",
"The installed version of this CGI is : ",  result, "\n\n",
"Solution : Restrict the access to this CGI using password protection,\n",
"or disable it if you do not use it\n",
"Risk factor : Low");

   security_warning(port:port, data: result);
   exit(0);
  } 
}
