# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 003-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53769);
 script_version ("$");
 name = "Debian Security Advisory DSA 003-1 (joe)";
 script_name(name);

 desc = "The remote host is missing an update to joe
announced via advisory DSA 003-1.

The security fix for joe released on November 22, 2000 had a problem:
it created the DEADJOE file securily but didn't write anything to it.
This has been fixed in version 2.8.15.2 .

This is the text from the previous advisory:

When joe (Joe's Own Editor) dies due to a signal instead of a normal
exit it saves a list of the files it is editing to a file called `DEADJOE'
in its current directory. Unfortunately this wasn't done safely which made
joe vulnerable to a symlink attack.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20003-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 003-1 (joe)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"joe", ver:"2.8-15.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
