# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 010-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53861);
 script_version ("$");
 name = "Debian Security Advisory DSA 010-1 (gnupg)";
 script_name(name);

 desc = "The remote host is missing an update to gnupg
announced via advisory DSA 010-1.

Two bugs in GnuPG have recently been found:

1. false positives when verifying detached signatures
- -----------------------------------------------------

There is a problem in the way gpg checks detached signatures which
can lead to false positives. Detached signature can be verified
with a command like this:

gpg --verify detached.sig < mydata

If someone replaced detached.sig with a signed text (ie not a
detached signature) and then modified mydata gpg would still
report a successfully verified signature.

To fix the way the --verify option works has been changes: it now
needs two options when verifying detached signatures: both the file
with the detached signature, and the file with the data to be
verified. Please note that this makes it incompatible with older
versions!

2. secret keys are silently imported
- ------------------------------------

Florian Weimer discovered that gpg would import secret keys from
key-servers. Since gpg considers public keys corresponding to
known secret keys to be ultimately trusted an attacked can use this
circumvent the web of trust.

To fix this a new option was added to to tell gpg it is allowed
to import secret keys: --allow-key-import.


Both these fixes are in version 1.0.4-1.1 and we recommend that you
upgrade your gnupg package immediately.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20010-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 010-1 (gnupg)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnupg", ver:"1.0.4-1.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
