# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 065-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53817);
 script_version ("$");
 name = "Debian Security Advisory DSA 065-1 (samba)";
 script_name(name);

 desc = "The remote host is missing an update to samba
announced via advisory DSA 065-1.

Michal Zalewski discovered that samba does not properly validate
NetBIOS names from remote machines.

By itself that is not a problem, except if Samba is configure to
write log-files to a file that includes the NetBIOS name of the
remote side by using the `%m' macro in the `log file' command. In
that case an attacker could use a NetBIOS name like '../tmp/evil'.
If the log-file was set to '/var/log/samba/%s' samba would them
write to /var/tmp/evil.

Since the NetBIOS name is limited to 15 characters and the `log
file' command could have an extension to the filename the results
of this are limited. However if the attacker is also able to create
symbolic links on the samba server he could trick samba into
appending any data he wants to all files on the filesystem which
samba can write to.

The Debian GNU/Linux packaged version of samba has a safe
configuration and is not vulnerable.

As temporary workaround for systems that are vulnerable change all
occurrences of the `%m' macro in smb.conf to `%l' and restart samba.

This has been fixed in version 2.0.7-3.4, and we recommend that up
upgrade your samba package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20065-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 065-1 (samba)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"2.0.7-3.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"2.0.7-3.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"2.0.7-3.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"2.0.7-3.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"2.0.7-3.4", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"2.0.7-3.4", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
