# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 086-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53766);
 script_version ("$");
 name = "Debian Security Advisory DSA 086-1 (ssh-nonfree, ssh-socks)";
 script_name(name);

 desc = "The remote host is missing an update to ssh-nonfree, ssh-socks
announced via advisory DSA 086-1.

We have received reports that the SSH CRC-32 compensation attack
detector vulnerability is being actively exploited. This is the same
integer type error previously corrected for OpenSSH in DSA-027-1.
OpenSSH (the Debian ssh package) was fixed at that time, but
ssh-nonfree and ssh-socks were not.

Though packages in the non-free section of the archive are not
officially supported by the Debian project, we are taking the unusal
step of releasing updated ssh-nonfree/ssh-socks packages for those
users who have not yet migrated to OpenSSH. However, we do recommend
that our users migrate to the regularly supported, DFSG-free ssh
package as soon as possible. ssh 1.2.3-9.3 is the OpenSSH package
available in Debian 2.2r4.

The fixed ssh-nonfree/ssh-socks packages are available in version
1.2.27-6.2 for use with Debian 2.2 (potato) and version 1.2.27-8 for
use with the Debian unstable/testing distribution. Note that the new
ssh-nonfree/ssh-socks packages remove the setuid bit from the ssh
binary, disabling rhosts-rsa authentication. If you need this
functionality, run
chmod u+s /usr/bin/ssh1
after installing the new package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20086-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 086-1 (ssh-nonfree, ssh-socks)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssh-askpass-nonfree", ver:"1.2.27-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh-nonfree", ver:"1.2.27-6.2", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ssh-socks", ver:"1.2.27-6.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
