# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 095-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53575);
 script_version ("$");
 name = "Debian Security Advisory DSA 095-1 (gpm)";
 script_name(name);

 desc = "The remote host is missing an update to gpm
announced via advisory DSA 095-1.

The package 'gpm' contains the 'gpm-root' program, which can be used to
create mouse-activated menus on the console.
Among other problems, the gpm-root program contains a format string
vulnerability, which allows an attacker to gain root privileges.

This has been fixed in version 1.17.8-18.1, and we recommend that you upgrade


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20095-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 095-1 (gpm)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gpm", ver:"1.17.8-18.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgpmg1-dev", ver:"1.17.8-18.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgpmg1", ver:"1.17.8-18.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgpm1-altdev", ver:"1.17.8-18.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgpm1", ver:"1.17.8-18.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
