# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1011-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56463);
 script_cve_id("CVE-2005-4347", "CVE-2005-4418");
 script_version ("$");
 name = "Debian Security Advisory DSA 1011-1 (kernel-patch-vserver, util-vserver)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-patch-vserver, util-vserver
announced via advisory DSA 1011-1.

Several vulnerabilities have been discovered in the Debian vserver
support for Linux.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2005-4347

Bjrn Steinbrink discovered that the chroot barrier is not set
correctly with util-vserver which may result in unauthorised
escapes from a vserver to the host system.

This vulnerability is limited to the 2.4 kernel patch included in
kernel-patch-vserver.  The correction to this problem requires
updating the util-vserver package as well and installing a new
kernel built from the updated kernel-patch-vserver package.

CVE-2005-4418

The default policy of util-vserver is set to trust all unknown
capabilities instead of considering them as insecure.

The old stable distribution (woody) does not contain a
kernel-patch-vserver package.

For the stable distribution (sarge) this problem has been fixed in
version 1.9.5.5 of kernel-patch-vserver and in version
0.30.204-5sarge3 of util-vserver.

For the unstable distribution (sid) this problem has been fixed in
version 2.3 of kernel-patch-vserver and in version 0.30.208-1 of
util-vserver.

We recommend that you upgrade your util-vserver and

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201011-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1011-1 (kernel-patch-vserver, util-vserver)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-patch-vserver", ver:"1.9.5.5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"util-vserver", ver:"0.30.204-5sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
