# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1022-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56528);
 script_cve_id("CVE-2005-3146", "CVE-2005-3147", "CVE-2005-3148");
 script_version ("$");
 name = "Debian Security Advisory DSA 1022-1 (storebackup)";
 script_name(name);

 desc = "The remote host is missing an update to storebackup
announced via advisory DSA 1022-1.

Several vulnerabilities have been discovered in the backup utility
storebackup. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2005-3146

Storebackup creates a temporary file predictably, which can be
exploited to overwrite arbitrary files on the system with a symlink
attack.

CVE-2005-3147

The backup root directory is created with world-readable permissions,
which may leak sensitive data.

CVE-2005-3148

The user and group rights of symlinks are set incorrectly when making
or restoring a backup, which may leak sensitive data.

The old stable distribution (woody) doesn't contain storebackup packages.

For the stable distribution (sarge) these problems have been fixed in
version 1.18.4-2sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 1.19-2.

We recommend that you upgrade your storebackup package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201022-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1022-1 (storebackup)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"storebackup", ver:"1.18.4-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
