# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1031-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56530);
 script_cve_id("CVE-2006-0146", "CVE-2006-0147", "CVE-2006-0410", "CVE-2006-0806");
 script_bugtraq_id(16187,16364,16720);
 script_version ("$");
 name = "Debian Security Advisory DSA 1031-1 (cacti)";
 script_name(name);

 desc = "The remote host is missing an update to cacti
announced via advisory DSA 1031-1.

Several vulnerabilities have been discovered in libphp-adodb, the
'adodb' database abstraction layer for PHP, which is embedded in
cacti, a frontend to rrdtool for monitoring systems and services.  The
Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2006-0146

Andreas Sandblad discovered that improper user input sanitisation
results in a potential remote SQL injection vulnerability enabling
an attacker to compromise applications, access or modify data, or
exploit vulnerabilities in the underlying database implementation.
This requires the MySQL root password to be empty.  It is fixed by
limiting access to the script in question.

CVE-2006-0147

A dynamic code evaluation vulnerability allows remote attackers to
execute arbitrary PHP functions via the 'do' parameter.

CVE-2006-0410

Andy Staudacher discovered an SQL injection vulnerability due to
insufficient input sanitising that allows remote attackers to
execute arbitrary SQL commands.

CVE-2006-0806

GulfTech Security Research discovered multiple cross-site
scripting vulnerabilities due to improper user-supplied input
sanitisation.  Attackers can exploit these vulnerabilities to
cause arbitrary scripts to be executed in the browser of an
unsuspecting user's machine, or result in the theft of
cookie-based authentication credentials.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 0.8.6c-7sarge3.

For the unstable distribution these problems will be fixed soon.

We recommend that you upgrade your cacti package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201031-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1031-1 (cacti)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cacti", ver:"0.8.6c-7sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
