# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1089-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56859);
 script_cve_id("CVE-2005-4744", "CVE-2006-1354");
 script_bugtraq_id(17171,17293);
 script_version ("$");
 name = "Debian Security Advisory DSA 1089-1 (freeradius)";
 script_name(name);

 desc = "The remote host is missing an update to freeradius
announced via advisory DSA 1089-1.

Several problems have been discovered in freeradius, a
high-performance and highly configurable RADIUS server.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2005-4744

SuSE researchers have discovered several off-by-one errors may
allow remote attackers to cause a denial of service and possibly
execute arbitrary code.

CVE-2006-1354

Due to insufficient input validation it is possible for a remote
attacker to bypass authentication or cause a denial of service.

The old stable distribution (woody) does not contain this package.

For the stable distribution (sarge) this problem has been fixed in
version 1.0.2-4sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 1.1.0-1.2.

We recommend that you upgrade your freeradius package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201089-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1089-1 (freeradius)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freeradius-dialupadmin", ver:"1.0.2-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius", ver:"1.0.2-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-iodbc", ver:"1.0.2-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-krb5", ver:"1.0.2-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-ldap", ver:"1.0.2-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-mysql", ver:"1.0.2-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
