# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1095-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56934);
 script_cve_id("CVE-2006-0747", "CVE-2006-1861", "CVE-2006-2493", "CVE-2006-2661");
 script_bugtraq_id(18034);
 script_version ("$");
 name = "Debian Security Advisory DSA 1095-1 (freetype)";
 script_name(name);

 desc = "The remote host is missing an update to freetype
announced via advisory DSA 1095-1.

Several problems have been discovered in the FreeType 2 font engine.
The Common vulnerabilities and Exposures project identifies the
following problems:

CVE-2006-0747

Several integer underflows have been discovered which could allow
remote attackers to cause a denial of service.

CVE-2006-1861

Chris Evans discovered several integer overflows that lead to a
denial of service or could possibly even lead to the execution of
arbitrary code.

CVE-2006-2493

Several more integer overflows have been discovered which could
possibly lead to the execution of arbitrary code.

CVE-2006-2661

A null pointer dereference could cause a denial of service.

For the old stable distribution (woody) these problems have been fixed in
version 2.0.9-1woody1.

For the stable distribution (sarge) these problems have been fixed in
version 2.1.7-2.5.

For the unstable distribution (sid) these problems will be fixed soon

We recommend that you upgrade your libfreetype packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201095-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1095-1 (freetype)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freetype2-demos", ver:"2.0.9-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6", ver:"2.0.9-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6-dev", ver:"2.0.9-1woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freetype2-demos", ver:"2.1.7-2.5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6", ver:"2.1.7-2.5", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6-dev", ver:"2.1.7-2.5", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
