# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 114-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53393);
 script_version ("$");
 name = "Debian Security Advisory DSA 114-1 (gnujsp)";
 script_name(name);

 desc = "The remote host is missing an update to gnujsp
announced via advisory DSA 114-1.

Thomas Springer found a vulnerability in GNUJSP, a Java servlet that
allows you to insert Java source code into HTML files.  The problem
can be used to bypass access restrictions in the web server.  An
attacker can view the contents of directories and download files
directly rather then receiving their HTML output.  This means that the
source code of scripts could also be revealed.

The problem was fixed by Stefan Gybas, who maintains the Debian
package of GNUJSP.  It is fixed in version 1.0.0-5 for the stable
release of Debian GNU/Linux.

The versions in testing and unstable are the same as the one in stable
so they are vulnerable, too.  You can install the fixed version this
advisory refers to on these systems to solve the problem as this
package is architecture independent.

We recommend that you upgrade your gnujsp package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20114-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 114-1 (gnujsp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnujsp", ver:"1.0.0-5", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
