# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 115-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53395);
 script_version ("$");
 name = "Debian Security Advisory DSA 115-1 (php3, php4)";
 script_name(name);

 desc = "The remote host is missing an update to php3, php4
announced via advisory DSA 115-1.

Stefan Esser, who is also a member of the PHP team, found several
flaws in the way PHP handles multipart/form-data POST requests (as
described in RFC1867) known as POST fileuploads.  Each of the flaws
could allow an attacker to execute arbitrary code on the victim's
system.

For PHP3 flaws contain a broken boundary check and an arbitrary heap
overflow.  For PHP4 they consist of a broken boundary check and a heap
off by one error.

For the stable release of Debian these problems are fixed in version
3.0.18-0potato1.1 of PHP3 and version 4.0.3pl1-0potato3 of PHP4.

For the unstable and testing release of Debian these problems are
fixed in version 3.0.18-22 of PHP3 and version 4.1.2-1 of PHP4.

There is no PHP4 in the stable and unstable distribution for the arm
architecture due to a compiler error.

We recommend that you upgrade your php packages immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20115-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 115-1 (php3, php4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php3-doc", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-dev", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-gd", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-imap", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-ldap", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-magick", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-mhash", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-mysql", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-pgsql", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-snmp", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi-xml", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-cgi", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-dev", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-gd", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-imap", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-ldap", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-magick", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-mhash", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-mysql", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-pgsql", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-snmp", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3-xml", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php3", ver:"3.0.18-0potato1.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-gd", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-imap", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-ldap", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-mhash", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-mysql", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-pgsql", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-snmp", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi-xml", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pgsql", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xml", ver:"4.0.3pl1-0potato3", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
