# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1185-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57478);
 script_cve_id("CVE-2006-2940", "CVE-2006-3738", "CVE-2006-4343", "CVE-2006-2937");
 script_version ("$");
 name = "Debian Security Advisory DSA 1185-1 (openssl)";
 script_name(name);

 desc = "The remote host is missing an update to openssl
announced via advisory DSA 1185-1.

Multiple vulnerabilities have been discovered in the OpenSSL
cryptographic software package that could allow an attacker to launch
a denial of service attack by exhausting system resources or crashing
processes on a victim's computer.

CVE-2006-2937
Dr S N Henson of the OpenSSL core team and Open Network
Security recently developed an ASN1 test suite for NISCC
(www.niscc.gov.uk). When the test suite was run against
OpenSSL two denial of service vulnerabilities were discovered.

During the parsing of certain invalid ASN1 structures an error
condition is mishandled. This can result in an infinite loop
which consumes system memory.

Any code which uses OpenSSL to parse ASN1 data from untrusted
sources is affected. This includes SSL servers which enable
client authentication and S/MIME applications.

CVE-2006-3738
Tavis Ormandy and Will Drewry of the Google Security Team
discovered a buffer overflow in SSL_get_shared_ciphers utility
function, used by some applications such as exim and mysql.  An
attacker could send a list of ciphers that would overrun a
buffer.

CVE-2006-4343
Tavis Ormandy and Will Drewry of the Google Security Team
discovered a possible DoS in the sslv2 client code.  Where a
client application uses OpenSSL to make a SSLv2 connection to
a malicious server that server could cause the client to
crash.

CVE-2006-2940
Dr S N Henson of the OpenSSL core team and Open Network
Security recently developed an ASN1 test suite for NISCC
(www.niscc.gov.uk). When the test suite was run against
OpenSSL a DoS was discovered.

Certain types of public key can take disproportionate amounts
of time to process. This could be used by an attacker in a
denial of service attack.

For the stable distribution (sarge) these problems have been fixed in
version 0.9.7e-3sarge3.

For the unstable and testing distributions (sid and etch,
respectively), these problems will be fixed in version 0.9.7k-2 of the
openssl097 compatibility libraries, and version 0.9.8c-2 of the
openssl package.

We recommend that you upgrade your openssl package.  Note that

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201185-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1185-1 (openssl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.7e-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.7", ver:"0.9.7e-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.7e-3sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
