# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1201-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57563);
 script_cve_id("CVE-2006-4574", "CVE-2006-4805", "CVE-2005-4574");
 script_version ("$");
 name = "Debian Security Advisory DSA 1201-1 (ethereal)";
 script_name(name);

 desc = "The remote host is missing an update to ethereal
announced via advisory DSA 1201-1.

Several remote vulnerabilities have been discovered in the Ethereal network
scanner. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2005-4574

It was discovered that the MIME multipart dissector is vulnerable to
denial of service caused by an off-by-one overflow.

CVE-2006-4805

It was discovered that the XOT dissector is vulnerable to denial
of service caused by memory corruption.

For the stable distribution (sarge) these problems have been fixed in
version 0.10.10-2sarge9. Due to technical problems with the security
buildd infrastructure this update lacks builds for the hppa and sparc
architecture. They will be released as soon as the problems are resolved.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your ethereal packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201201-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1201-1 (ethereal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ethereal", ver:"0.10.10-2sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-common", ver:"0.10.10-2sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ethereal-dev", ver:"0.10.10-2sarge9", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tethereal", ver:"0.10.10-2sarge9", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
