# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1207-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57579);
 script_cve_id("CVE-2006-1678", "CVE-2006-2418", "CVE-2005-3621", "CVE-2005-3665", "CVE-2006-5116");
 script_version ("$");
 name = "Debian Security Advisory DSA 1207-1 (phpmyadmin)";
 script_name(name);

 desc = "The remote host is missing an update to phpmyadmin
announced via advisory DSA 1207-1.

Several remote vulnerabilities have been discovered in phpMyAdmin, a
program to administrate MySQL over the web. The Common Vulnerabilities
and Exposures project identifies the following problems:

CVE-2005-3621

CRLF injection vulnerability allows remote attackers to conduct
HTTP response splitting attacks.

CVE-2005-3665

Multiple cross-site scripting (XSS) vulnerabilities allow remote
attackers to inject arbitrary web script or HTML via the (1) HTTP_HOST
variable and (2) various scripts in the libraries directory that
handle header generation.

CVE-2006-1678

Multiple cross-site scripting (XSS) vulnerabilities allow remote
attackers to inject arbitrary web script or HTML via scripts in the
themes directory.

CVE-2006-2418

A cross-site scripting (XSS) vulnerability allows remote attackers
to inject arbitrary web script or HTML via the db parameter of
footer.inc.php.

CVE-2006-5116

A remote attacker could overwrite internal variables through the
_FILES global variable.

For the stable distribution (sarge) these problems have been fixed in
version 2.6.2-3sarge2.

For the upcoming stable release (etch) and unstable distribution (sid)
these problems have been fixed in version 2.9.0.3-1.

We recommend that you upgrade your phpmyadmin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201207-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1207-1 (phpmyadmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpmyadmin", ver:"2.6.2-3sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
