# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1227-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57691);
 script_cve_id("CVE-2006-4310", "CVE-2006-5462", "CVE-2006-5463", "CVE-2006-5464", "CVE-2006-5748");
 script_bugtraq_id(19678,20957);
 script_version ("$");
 name = "Debian Security Advisory DSA 1227-1 (mozilla-thunderbird)";
 script_name(name);

 desc = "The remote host is missing an update to mozilla-thunderbird
announced via advisory DSA 1227-1.

Several security related problems have been discovered in Mozilla and
derived products such as Mozilla Thunderbird.  The Common Vulnerabilities
and Exposures project identifies the following vulnerabilities:

CVE-2006-4310

Tomas Kempinsky discovered that malformed FTP server responses
could lead to denial of service.

CVE-2006-5462

Ulrich Khn discovered that the correction for a cryptographic
flaw in the handling of PKCS-1 certificates was incomplete, which
allows the forgery of certificates.

CVE-2006-5463

shutdown discovered that modification of JavaScript objects
during execution could lead to the execution of arbitrary
JavaScript bytecode.

CVE-2006-5464

Jesse Ruderman and Martijn Wargers discovered several crashes in
the layout engine, which might also allow execution of arbitrary
code.

CVE-2006-5748

Igor Bukanov and Jesse Ruderman discovered several crashes in the
JavaScript engine, which might allow execution of arbitrary code.

This update also adresses several crashes, which could be triggered by
malicious websites and fixes a regression introduced in the previous
Mozilla update.


For the stable distribution (sarge) these problems have been fixed in
version 1.0.4-2sarge13.

For the unstable distribution (sid) these problems have been fixed in
the current icedove package 1.5.0.8.

We recommend that you upgrade your mozilla-thunderbird package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201227-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1227-1 (mozilla-thunderbird)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.0.2-2.sarge1.0.8d.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.0.2-2.sarge1.0.8d.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.0.2-2.sarge1.0.8d.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-offline", ver:"1.0.2-2.sarge1.0.8d.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.0.2-2.sarge1.0.8d.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
