# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 122-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53398);
 script_bugtraq_id(4267);
 script_cve_id("CVE-2002-0059");
 script_version ("$");
 name = "Debian Security Advisory DSA 122-1 (zlib, various)";
 script_name(name);

 desc = "The remote host is missing an update to zlib, various
announced via advisory DSA 122-1.

The compression library zlib has a flaw in which it attempts to free
memory more than once under certain conditions. This can possibly be
exploited to run arbitrary code in a program that includes zlib. If a
network application running as root is linked to zlib, this could
potentially lead to a remote root compromise. No exploits are known at
this time. This vulnerability is assigned the CVE candidate name of
CVE-2002-0059.

The zlib vulnerability is fixed in the Debian zlib package version
1.1.3-5.1. A number of programs either link statically to zlib or include
a private copy of zlib code. These programs must also be upgraded
to eliminate the zlib vulnerability. The affected packages and fixed
versions follow:
amaya 2.4-1potato1
dictd 1.4.9-9potato1
erlang 49.1-10.1
freeamp 2.0.6-2.1
mirrordir 0.10.48-2.1
ppp 2.3.11-1.5
rsync 2.3.2-1.6
vrweb 1.5-5.1

Those using the pre-release (testing) version of Debian should upgrade
to zlib 1.1.3-19.1 or a later version. Note that since this version of
Debian has not yet been released it may not be available immediately for
all architectures. Debian 2.2 (potato) is the latest supported release.

We recommend that you upgrade your packages immediately. Note that you


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20122-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 122-1 (zlib, various)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"erlang-base", ver:"49.1-10.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"erlang-erl", ver:"49.1-10.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"erlang-java", ver:"49.1-10.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeamp-doc", ver:"2.0.6-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"amaya", ver:"2.4-1potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dict", ver:"1.4.9-9potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dictd", ver:"1.4.9-9potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mirrordir", ver:"0.10.48-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ppp", ver:"2.3.11-1.5", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rsync", ver:"2.3.2-1.6", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"vrweb", ver:"1.5-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib-bin", ver:"1.1.3-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib1g-dev", ver:"1.1.3-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib1g", ver:"1.1.3-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"erlang", ver:"49.1-10.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeamp", ver:"2.0.6-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreeamp-alsa", ver:"2.0.6-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreeamp-esound", ver:"2.0.6-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib1-altdev", ver:"1.1.3-5.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"zlib1", ver:"1.1.3-5.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
