# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1273-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58325);
 script_cve_id("CVE-2007-1543", "CVE-2007-1544", "CVE-2007-1545", "CVE-2007-1546", "CVE-2007-1547");
 script_bugtraq_id(23017);
 script_version ("$");
 name = "Debian Security Advisory DSA 1273-1 (nas)";
 script_name(name);

 desc = "The remote host is missing an update to nas
announced via advisory DSA 1273-1.

Several vulnerabilities have been discovered in nas, the Network Audio
System.

CVE-2007-1543

A stack-based buffer overflow in the accept_att_local function in
server/os/connection.c in nas allows remote attackers to execute
arbitrary code via a long path slave name in a USL socket connection.

CVE-2007-1544

Integer overflow in the ProcAuWriteElement function in
server/dia/audispatch.c allows remote attackers to cause a denial of
service (crash) and possibly execute arbitrary code via a large
max_samples value.

CVE-2007-1545

The AddResource function in server/dia/resource.c allows remote
attackers to cause a denial of service (server crash) via a
nonexistent client ID.

CVE-2007-1546

Array index error allows remote attackers to cause a denial of service
(crash) via (1) large num_action values in the ProcAuSetElements
function in server/dia/audispatch.c or (2) a large inputNum parameter
to the compileInputs function in server/dia/auutil.c.

CVE-2007-1547

The ReadRequestFromClient function in server/os/io.c allows remote
attackers to cause a denial of service (crash) via multiple
simultaneous connections, which triggers a NULL pointer dereference.


For the stable distribution (sarge), these problems have been fixed in
version 1.7-2sarge1

For the upcoming stable distribution (etch) and the unstable
distribution (sid) these packages have been fixed in version 1.8-4.

We recommend that you upgrade your nas package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201273-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1273-1 (nas)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nas-doc", ver:"1.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaudio2", ver:"1.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaudio-dev", ver:"1.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nas-bin", ver:"1.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nas", ver:"1.7-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
