# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1275-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58327);
 script_cve_id("CVE-2007-0240");
 script_bugtraq_id(23084);
 script_version ("$");
 name = "Debian Security Advisory DSA 1275-1 (zope2.7)";
 script_name(name);

 desc = "The remote host is missing an update to zope2.7
announced via advisory DSA 1275-1.

A cross-site scripting vulnerability in zope, a web application
server, could allow an attacker to inject arbitrary HTML and/or
JavaScript into the victim's web browser.  This code would run within
the security context of the web browser, potentially allowing the
attacker to access private data such as authentication cookies, or to
affect the rendering or behavior of zope web pages.

For the stable distribution (sarge), this problem has been fixed in
version 2.7.5-2sarge4

The upcoming stable distribution (etch) and the unstable distribution
(sid) include zope2.9, and this vulnerability is fixed in version
2.9.6-4etch1 for etch and 2.9.7-1 for sid.

We recommend that you upgrade your zope2.7 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201275-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1275-1 (zope2.7)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zope2.7", ver:"2.7.5-2sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
