# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1291-4
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58349);
 script_cve_id("CVE-2007-2444", "CVE-2007-2446", "CVE-2007-2447");
 script_version ("$");
 name = "Debian Security Advisory DSA 1291-4 (samba)";
 script_name(name);

 desc = "The remote host is missing an update to samba
announced via advisory DSA 1291-4.

The security update for CVE-2007-2446 introduced a regression, which
broke connection to domain member servers in some scenarios. This update
fixes this regression.

For the stable distribution (etch), this regression has been fixed in
version 3.0.24-6etch4.

The old stable distribution (sarge) is not affected by this problem.

For the unstable distribution (sid) this regression has been fixed in
version 3.0.25a-1.

We recommend that you upgrade your samba package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201291-4

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1291-4 (samba)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-samba", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.0.24-6etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
