# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1340-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58472);
 script_cve_id("CVE-2007-3725");
 script_version ("$");
 name = "Debian Security Advisory DSA 1340-1 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory DSA 1340-1.

A NULL pointer dereference has been discovered in the RAR VM of Clam
Antivirus (ClamAV) which allows user-assisted remote attackers to
cause a denial of service via a specially crafted RAR archives.

We are currently unable to provide fixed packages for the MIPS
architectures.  Those packages will be installed in the security
archive when they become available.

The old stable distribution (sarge) is not affected by this problem.

For the stable distribution (etch) this problem has been fixed in
version 0.90.1-3etch4.

For the unstable distribution (sid) this problem has been fixed in
version 0.91-1.

We recommend that you upgrade your clamav packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201340-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1340-1 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-base", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav2", ver:"0.90.1-3etch4", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
