# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1396-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58695);
 script_cve_id("CVE-2007-1095", "CVE-2007-2292", "CVE-2007-3511", "CVE-2007-5334", "CVE-2007-5337", "CVE-2007-5338", "CVE-2007-5339", "CVE-2007-5340", "CVE-2006-2894");
 script_version ("$");
 name = "Debian Security Advisory DSA 1396-1 (icedove)";
 script_name(name);

 desc = "The remote host is missing an update to icedove
announced via advisory DSA 1396-1.

Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-1095

Michal Zalewski discovered that the unload event handler had access to
the address of the next page to be loaded, which could allow information
disclosure or spoofing.

CVE-2007-2292

Stefano Di Paola discovered that insufficient validation of user names
used in Digest authentication on a web site allows HTTP response splitting
attacks.

CVE-2007-3511

It was discovered that insecure focus handling of the file upload
control can lead to information disclosure. This is a variant of
CVE-2006-2894.

CVE-2007-5334

Eli Friedman discovered that web pages written in Xul markup can hide the
titlebar of windows, which can lead to spoofing attacks.

CVE-2007-5337

Georgi Guninski discovered the insecure handling of smb:// and sftp:// URI
schemes may lead to information disclosure. This vulnerability is only
exploitable if Gnome-VFS support is present on the system.

CVE-2007-5338

moz_bug_r_a4 discovered that the protection scheme offered by XPCNativeWrappers
could be bypassed, which might allow privilege escalation.

CVE-2007-5339

L. David Baron, Boris Zbarsky, Georgi Guninski, Paul Nickerson, Olli Pettay,
Jesse Ruderman, Vladimir Sukhoy, Daniel Veditz, and Martijn Wargers discovered
crashes in the layout engine, which might allow the execution of arbitrary code.

CVE-2007-5340

Igor Bukanov, Eli Friedman, and Jesse Ruderman discovered crashes in the
Javascript engine, which might allow the execution of arbitrary code.

The Mozilla products in the oldstable distribution (sarge) are no longer
supported with with security updates.

For the stable distribution (etch) these problems have been fixed in version
2.0.0.6+2.0.0.8-0etch1. Builds for arm and sparc will be provided later.

For the unstable distribution (sid) these problems have been fixed in version
2.0.0.8-1.

We recommend that you upgrade your iceweasel packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201396-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1396-1 (icedove)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.6+2.0.0.8-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.6-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
