# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1398-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58730);
 script_cve_id("CVE-2007-5740");
 script_version ("$");
 name = "Debian Security Advisory DSA 1398-1 (perdition)";
 script_name(name);

 desc = "The remote host is missing an update to perdition
announced via advisory DSA 1398-1.

Bernhard Mueller of SEC Consult has discovered a format string
vulnerability in perdition, an IMAP proxy.  This vulnerabilty could
allow an unauthenticated remote user to run arbitrary code on the
perdition server by providing a specially formatted IMAP tag.

For the stable distribution (etch), this problem has been fixed in
version 1.17-7etch1

For the old stable distribution (sarge), this problem has been fixed in
version 1.15-5sarge1

We recommend that you upgrade your perdition package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201398-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1398-1 (perdition)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"perdition", ver:"1.15-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-odbc", ver:"1.15-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-mysql", ver:"1.15-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-ldap", ver:"1.15-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-dev", ver:"1.15-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-postgresql", ver:"1.15-5sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-mysql", ver:"1.17-7etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-dev", ver:"1.17-7etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-ldap", ver:"1.17-7etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition", ver:"1.17-7etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-postgresql", ver:"1.17-7etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perdition-odbc", ver:"1.17-7etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
