# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1415-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59640);
 script_cve_id("CVE-2007-5378");
 script_version ("$");
 name = "Debian Security Advisory DSA 1415-1 (tk8.4)";
 script_name(name);

 desc = "The remote host is missing an update to tk8.4
announced via advisory DSA 1415-1.

It was discovered that Tk, a cross-platform graphical toolkit for Tcl
performs insufficient input validation in the code used to load GIF
images, which may lead to the execution of arbitrary code.

For the stable distribution (etch), this problem has been fixed in
version 8.4.12-1etch1.

For the old stable distribution (sarge), this problem has been fixed
in version 8.4.9-1sarge1.

We recommend that you upgrade your tk8.4 packages. Updated packages for

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201415-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1415-1 (tk8.4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tk8.4-doc", ver:"8.4.12-1etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4-dev", ver:"8.4.12-1etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tk8.4", ver:"8.4.12-1etch1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
