# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1436-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60047);
 script_cve_id("CVE-2006-6058", "CVE-2007-5966", "CVE-2007-6063", "CVE-2007-6206", "CVE-2007-6417");
 script_version ("$");
 name = "Debian Security Advisory DSA 1436-1 (linux-2.6)";
 script_name(name);

 desc = "The remote host is missing an update to linux-2.6
announced via advisory DSA 1436-1.

Several local vulnerabilities have been discovered in the Linux kernel
that may lead to a denial of service or the execution of arbitrary
code. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2006-6058

LMH reported an issue in the minix filesystem that allows local users
with mount privileges to create a DoS (printk flood) by mounting a
specially crafted corrupt filesystem.

CVE-2007-5966

Warren Togami discovered an issue in the hrtimer subsystem that allows
a local user to cause a DoS (soft lockup) by requesting a timer sleep
for a long period of time leading to an integer overflow.

CVE-2007-6063

Venustech AD-LAB discovered a a buffer overflow in the isdn ioctl
handling, exploitable by a local user.

CVE-2007-6206

Blake Frantz discovered that when a core file owned by a non-root user
exists, and a root-owned process dumps core over it, the core file
retains its original ownership. This could be used by a local user to
gain access to sensitive information.

CVE-2007-6417

Hugh Dickins discovered an issue in the tmpfs filesystem where, under
a rare circumstance, a kernel page maybe improperly cleared, leaking
sensitive kernel memory to userspace or resulting in a DoS (crash).

These problems have been fixed in the stable distribution in version
2.6.18.dfsg.1-13etch6.

The following matrix lists additional packages that were rebuilt for
compatability with or to take advantage of this update:

Debian 4.0 (etch)
fai-kernels                 1.17+etch.13etch6
user-mode-linux             2.6.18-1um-2etch.13etch6

We recommend that you upgrade your kernel package immediately and reboot

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201436-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1436-1 (linux-2.6)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-doc-2.6.18", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.18", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.18", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.18", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-support-2.6.18-5", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-tree-2.6.18", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-alpha", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-alpha-generic", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-alpha-legacy", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-alpha-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-alpha", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-alpha-generic", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-alpha-legacy", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-alpha-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-alpha", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-xen", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-xen-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-xen-vserver", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-xen-vserver-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-xen-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-xen-vserver-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-5-xen-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-5-xen-vserver-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-5-xen-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-5-xen-vserver-amd64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fai-kernels", ver:"1.17+etch.13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-arm", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-footbridge", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-iop32x", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-ixp4xx", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-rpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-s3c2410", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-footbridge", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-iop32x", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-ixp4xx", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-rpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-s3c2410", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-hppa", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-parisc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-parisc-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-parisc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-parisc64-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-parisc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-parisc-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-parisc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-parisc64-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-486", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-686-bigmem", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-i386", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-k7", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-k7", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-xen-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-xen-vserver-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-486", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-686-bigmem", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-k7", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-k7", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-xen-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-xen-vserver-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-5-xen-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.18-5-xen-vserver-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-5-xen-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.18-5-xen-vserver-686", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"user-mode-linux", ver:"2.6.18-1um-2etch.13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-ia64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-itanium", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-mckinley", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-itanium", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-mckinley", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-mips", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-qemu", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-r4k-ip22", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-r5k-ip32", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-sb1-bcm91250a", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-sb1a-bcm91480b", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-qemu", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-r4k-ip22", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-r5k-ip32", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-sb1-bcm91250a", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-sb1a-bcm91480b", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-mipsel", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-r3k-kn02", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-r4k-kn04", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-r5k-cobalt", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-r3k-kn02", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-r4k-kn04", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-r5k-cobalt", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-powerpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-powerpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-powerpc-miboot", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-powerpc-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-powerpc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-prep", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-powerpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-powerpc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-powerpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-powerpc-miboot", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-powerpc-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-powerpc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-prep", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-powerpc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-powerpc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-s390", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-s390", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-s390x", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-s390x", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-s390", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-s390-tape", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-s390x", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-s390x", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-all-sparc", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-sparc32", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-sparc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-sparc64-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.18-5-vserver-sparc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-sparc32", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-sparc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-sparc64-smp", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.18-5-vserver-sparc64", ver:"2.6.18.dfsg.1-13etch6", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
