# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1444-1 (php5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60099);
 script_cve_id("CVE-2007-3799", "CVE-2007-3998", "CVE-2007-4657", "CVE-2007-4658", "CVE-2007-4659", "CVE-2007-4660", "CVE-2007-4662", "CVE-2007-5898", "CVE-2007-5899");
 script_version ("$");
 name = "Debian Security Advisory DSA 1444-1 (php5)";
 script_name(name);

 desc = "The remote host is missing an update to php5
announced via advisory DSA 1444-1.

Several remote vulnerabilities have been discovered in PHP, a
server-side, HTML-embedded scripting language. The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2007-3799

It was discovered that the session_start() function allowed the
insertion of attributes into the session cookie.

CVE-2007-3998

Mattias Bengtsson and Philip Olausson discovered that a
programming error in the implementation of the wordwrap() function
allowed denial of service through an infinite loop.

CVE-2007-4658

Stanislav Malyshev discovered that a format string vulnerability
in the money_format() function could allow the execution of
arbitrary code.

CVE-2007-4659

Stefan Esser discovered that execution control flow inside the
zend_alter_ini_entry() function in handled incorrectly in case
of a memory limit violation.

CVE-2007-4660

Gerhard Wagner discovered an integer overflow inside the
chunk_split function().

CVE-2007-5898

Rasmus Lerdorf discovered that incorrect parsing of multibyte
sequences may lead to disclosure of memory contents.

CVE-2007-5899

It was discovered that the output_add_rewrite_var() function could
leak session ID information, resulting in information disclosure.

This update also fixes two bugs from in the PHP 5.2.4 release which
don't have security impact according to the Debian PHP security policy
(CVE-2007-4657 and CVE-2007-4662), but which are fixed nonetheless.


For the stable distribution (etch), these problems have been fixed in
version 5.2.0-8+etch9.

The old stable distribution (sarge) doesn't contain php5.

For the unstable distribution (sid), these problems have been fixed
in version 5.2.4-1, with the exception of CVE-2007-5898 and
CVE-2007-5899, which will be fixed soon. Please note that Debian's
version of PHP is hardened with the Suhosin patch beginning with
version 5.2.4-1, which renders several vulnerabilities ineffective.

We recommend that you upgrade your php5 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201444-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1444-1 (php5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php5", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mcrypt", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php5", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-imap", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.0-8+etch9", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-interbase", ver:"5.2.0-8+etch8", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
